/*
 * ACME - a crossassembler for producing 6502/65c02/65816 code.
 * Copyright (C) 1998 Marco Baye
 * Have a look at "acme.c" for further info
 */

/*
 * Stream stuff
 */

#ifndef stream_H
#define stream_H

/* Handles of byte sources */
enum {
  BYTESOURCE_FILE,
  BYTESOURCE_RAM
};

/*
 * Prototypes
 */
static int    ffOpenFiles = 0;/* If bit is set, corresponding file is open */
#define FOPENED_TOP     (1u << 0)
#define FOPENED_SUB     (1u << 1)
static FILE  *hfTop,
             *hfSub;/* File handles */
#define OUTBUFFERSIZE   65536
static char   OutputBuffer[OUTBUFFERSIZE];/* to hold assembled code */
static char   pPathname[LNPMAX + 1];/* universal file name */
static char  *psLibPath;/* Pointer to header string of library tree */
#define NO_QUOTE_CHAR   0
static char   QuoteChar = NO_QUOTE_CHAR;/* Current quoting character */
static char   FN_Stream_ConvertNL(void);
static char   FN_Stream_GetRawByte(void);
static char   FN_GetByte(void);
static int    FN_Stream_ReadKeyword(char *, int, int);
static int    FN_Stream_ReadFilename(char *, int, int);
static int    FN_Stream_FinishQuoted(char *, int, int);
static int    FN_Stream_Comma(void);
static void   FN_Stream_PutCodeByte(char);
static void   FN_Stream_PutByte(Value);
static int    FN_Stream_OpenTop(void);
static int    FN_Stream_OpenSub(char *);
static void   FN_Stream_CloseTop(void);
static void   FN_Stream_CloseSub(void);
static void   FN_Stream_Dump(void);
static void   FN_Stream_Output(Value, Value);

#endif
